#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>

namespace NInfra::NPodAgent {

class TPortoGetDownloadProgressNode;
using TPortoGetDownloadProgressNodePtr = TSimpleSharedPtr<TPortoGetDownloadProgressNode>;

class TPortoGetDownloadProgressNode : public TPortoBasicNode<TExpected<TString, TPortoError>> {
public:
    TPortoGetDownloadProgressNode(
        const TBasicTreeNodeDescriptor& destriptor
        , TAsyncPortoClientPtr porto
        , const TStatusRepositoryCommonPtr containerStatusRepository
        , const TPortoContainerName& containerName
        , const TString& objectIdOrHash
        , bool needCheckDownloadProgress
    )
        : TPortoBasicNode(destriptor, porto)
        , ContainerStatusRepository_(containerStatusRepository)
        , ContainerName_(containerName)
        , ObjectIdOrHash_(objectIdOrHash)
        , NeedCheckDownloadProgress_(needCheckDownloadProgress)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;

    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<TString, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_GET_DOWNLOAD_PROGRESS;

private:
    const TStatusRepositoryCommonPtr ContainerStatusRepository_;
    const TPortoContainerName ContainerName_;
    const TString ObjectIdOrHash_;
    const bool NeedCheckDownloadProgress_;
};

} // namespace NInfra::NPodAgent
