#include "porto_get_private_node.h"

namespace NInfra::NPodAgent {

template <>
ENodeType TPortoGetContainerPrivateNode::GetType() const {
    return TPortoGetContainerPrivateNode::NODE_TYPE;
}

template <>
ENodeType TPortoGetLayerPrivateNode::GetType() const {
    return TPortoGetLayerPrivateNode::NODE_TYPE;
}

template <>
TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> TPortoGetContainerPrivateNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->GetProperty(Name_, EPortoContainerProperty::Private);
}

template <>
TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> TPortoGetLayerPrivateNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->GetLayerPrivate(Name_, Place_);
}

} // namespace NInfra::NPodAgent
