#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/base/private_util.h>

namespace NInfra::NPodAgent {

template <class TEnum, class TName, EPortoError ErrorNotExist, ENodeType NodeType>
class TPortoGetPrivateNode;

using TPortoGetContainerPrivateNode = TPortoGetPrivateNode<EContainerPrivate, TPortoContainerName, EPortoError::ContainerDoesNotExist, ENodeType::PORTO_GET_CONTAINER_PRIVATE>;
using TPortoGetLayerPrivateNode = TPortoGetPrivateNode<ELayerPrivate, TString, EPortoError::LayerNotFound, ENodeType::PORTO_GET_LAYER_PRIVATE>;

using TPortoGetContainerPrivateNodePtr = TSimpleSharedPtr<TPortoGetContainerPrivateNode>;
using TPortoGetLayerPrivateNodePtr = TSimpleSharedPtr<TPortoGetLayerPrivateNode>;

template<class TEnum, class TName, EPortoError ErrorNotExist, ENodeType NodeType>
class TPortoGetPrivateNode : public TPortoBasicNode<TExpected<TString, TPortoError>> {
public:
    TPortoGetPrivateNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TName& name
        , const TString place
        , const TString& treeHash
    )
        : TPortoBasicNode(descriptor, porto)
        , Name_(name)
        , Place_(place)
        , TreeHash_(treeHash)

    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;

    virtual TTickResult ProcessPortoResult(TTickContextPtr /*context*/, TExpected<TString, TPortoError>& result) override final {
        if (!result) {
            if (result.Error().Code == ErrorNotExist) {
                return TNodeSuccess{ENodeStatus::SUCCESS, ToString(TEnum(0))};
            }
            return TNodeError{ToString(result.Error())};
        }
        TPrivateUnpacked<TEnum> unpacked = UnpackPrivate<TEnum>(result.Success());
        if (unpacked.TreeHash_ != TreeHash_) {
            return TNodeSuccess{ENodeStatus::SUCCESS, ToString(TEnum(0))};
        }
        return TNodeSuccess(ENodeStatus::SUCCESS, ToString(unpacked.Value_));
    }

public:
    static constexpr const ENodeType NODE_TYPE = NodeType;

private:
    const TName Name_;
    const TString Place_;
    const TString TreeHash_;
};

} // namespace NInfra::NPodAgent
