#include "porto_import_layer_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoImportLayerNode::GetType() const {
    return TPortoImportLayerNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> TPortoImportLayerNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->ImportLayer(LayerName_, LayerPath_, false, LayerPlace_, PackLayerPrivate({LP_EMPTY, TreeHash_}));
}

TTickResult TPortoImportLayerNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<void, TPortoError>& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        LayerStatusRepository_->UpdateObjectFailedMessage(LayerDownloadHash_, ToString(result.Error()));
        LayerStatusRepository_->IncrementObjectFailCounter(LayerDownloadHash_);
        if (result.Error().Code == EPortoError::NoSpace
            || result.Error().Code == EPortoError::Busy
            || result.Error().Code == EPortoError::LayerAlreadyExists
            // If layer archive is invalid, we get "InvalidValue(Cannot detect archive <...> compression by magic)"
            || result.Error().Code == EPortoError::InvalidValue
            // Tar error is interpreted as Unknown, we can get the real reason only from message
            || (result.Error().Code == EPortoError::Unknown && result.Error().Message.Contains("Disk quota exceeded"))
        ) {
            return TNodeSuccess(ENodeStatus::FAILURE, ToString(result.Error()));
        } else {
            return TNodeError({ToString(result.Error())});
        }
    }
}

} // namespace NInfra::NPodAgent
