#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/base/private_util.h>

#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository.h>

namespace NInfra::NPodAgent {

class TPortoImportLayerNode;
using TPortoImportLayerNodePtr = TSimpleSharedPtr<TPortoImportLayerNode>;

class TPortoImportLayerNode : public TPortoBasicNode<TExpected<void, TPortoError>> {
public:
    TPortoImportLayerNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TLayerStatusRepositoryPtr layerStatusRepository
        , const TString& layerDownloadHash
        , const TString& layerName
        , const TString& layerPlace
        , const TString& layerPath
        , const TString& treeHash
    )
        : TPortoBasicNode(descriptor, porto)
        , LayerStatusRepository_(layerStatusRepository)
        , LayerDownloadHash_(layerDownloadHash)
        , LayerName_(layerName)
        , LayerPlace_(layerPlace)
        , LayerPath_(layerPath)
        , TreeHash_(treeHash)
    {
        Y_ENSURE(LayerStatusRepository_, "LayerStatusRepository not defined for TPortoImportLayerNode");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<void, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_IMPORT_LAYER;

private:
    const TLayerStatusRepositoryPtr LayerStatusRepository_;

    const TString LayerDownloadHash_;
    const TString LayerName_;
    const TString LayerPlace_;
    const TString LayerPath_;
    const TString TreeHash_;
};

} // namespace NInfra::NPodAgent
