#include "porto_kill_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoKillNode::GetType() const {
    return TPortoKillNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> TPortoKillNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->Kill(ContainerName_, SIGKILL);
}

TTickResult TPortoKillNode::ProcessPortoResultError(TTickContextPtr context, TPortoError& result) {
    // Process error
    auto pResult = TPortoBasicContainerNode<void>::ProcessPortoResultError(context, result);

    // Special cases
    if (result.Code == EPortoError::Busy
        || result.Code == EPortoError::ContainerDoesNotExist
        || result.Code == EPortoError::InvalidState
        // Bad signal value
        || result.Code == EPortoError::InvalidValue
        // This error is interpreted as Unknown, we can get the real reason only from message
        || (result.Code == EPortoError::Unknown && result.Message.Contains("No such process"))
    ) {
        return TNodeSuccess(ENodeStatus::FAILURE, ToString(result));
    } else {
        return pResult;
    }
}

} // namespace NInfra::NPodAgent
