#include "porto_layer_exists_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoLayerExistsNode::GetType() const {
    return TPortoLayerExistsNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TVector<TPortoLayer>, TPortoError>>, TTickResult> TPortoLayerExistsNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->ListLayers(Place_, Layer_);
}

TTickResult TPortoLayerExistsNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<TVector<TPortoLayer>, TPortoError>& result) {
    if (result) {
        return result.Success().size() ? TNodeSuccess(ENodeStatus::SUCCESS) : TNodeSuccess(ENodeStatus::FAILURE, "Layer not found");
    } else {
        return TNodeError({ToString(result.Error())});
    }
}

} // namespace NInfra::NPodAgent
