#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

namespace NInfra::NPodAgent {

class TPortoLayerExistsNode;
using TPortoLayerExistsNodePtr = TSimpleSharedPtr<TPortoLayerExistsNode>;

class TPortoLayerExistsNode : public TPortoBasicNode<TExpected<TVector<TPortoLayer>, TPortoError>> {
public:
    TPortoLayerExistsNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TString& layer
        , const TString& place
    )
        : TPortoBasicNode(descriptor, porto)
        , Layer_(layer)
        , Place_(place)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TVector<TPortoLayer>, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<TVector<TPortoLayer>, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_LAYER_EXISTS;

private:
    const TString Layer_;
    const TString Place_;
};

} // namespace NInfra::NPodAgent
