#include "porto_layers_ready_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoLayersReadyNode::GetType() const {
    return TPortoLayersReadyNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TVector<TPortoLayer>, TPortoError>>, TTickResult> TPortoLayersReadyNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->ListLayers(Place_, "");
}

TTickResult TPortoLayersReadyNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<TVector<TPortoLayer>, TPortoError>& result) {
    if (result) {
        size_t foundCount = 0;
        for (const auto& layer: result.Success()) {
            auto it = Patterns_.find(layer.name());
            if (it != Patterns_.end()) {
                const auto& name = it->first;
                const auto& hash = it->second;
                ++foundCount;
                TLayerPrivateUnpacked unpacked = UnpackLayerPrivate(layer.private_value());
                if (unpacked.Value_ == LP_EXTRACTION_FAILURE) {
                    return TNodeSuccess{ENodeStatus::FAILURE, TStringBuilder()
                        << "format of hash '" << layer.private_value() << "' of layer '" << name << "' is incorrect"};
                }
                if (unpacked.TreeHash_ != hash) {
                    return TNodeSuccess{ENodeStatus::FAILURE, TStringBuilder()
                        << "layer " << layer.name() << " has incorrect tree hash "
                        << UnpackLayerPrivate(layer.private_value()).TreeHash_
                        << " instead of " << hash};
                }
            }
        }

        if (foundCount < Patterns_.size()) {
            return TNodeSuccess{ENodeStatus::FAILURE, TStringBuilder() << "among " << Patterns_.size() << " layers only " << foundCount << " were found"};
        }

        return TNodeSuccess{ENodeStatus::SUCCESS};
    }

    return TNodeError({ToString(result.Error())});
}

} // namespace NInfra::NPodAgent
