#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/base/private_util.h>

namespace NInfra::NPodAgent {

class TPortoLayersReadyNode;
using TPortoLayersReadyNodePtr = TSimpleSharedPtr<TPortoLayersReadyNode>;

class TPortoLayersReadyNode : public TPortoBasicNode<TExpected<TVector<TPortoLayer>, TPortoError>> {
public:
    TPortoLayersReadyNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TString& place
        , const TVector<TString>& layers
        , const TVector<TString>& treeHashes
    )
        : TPortoBasicNode(descriptor, porto)
        , Place_(place)
    {
        Y_ENSURE(layers.size() == treeHashes.size(), "number of layers and tree hashes are unequal");
        for (size_t i = 0; i < layers.size(); ++i) {
            Patterns_[layers[i]] = treeHashes[i];
        }
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TVector<TPortoLayer>, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<TVector<TPortoLayer>, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_LAYERS_READY;

private:
    const TString Place_;
    THashMap<TString, TString> Patterns_;
};

} // namespace NInfra::NPodAgent
