#include "porto_link_volume_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoLinkVolumeNode::GetType() const {
    return TPortoLinkVolumeNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> TPortoLinkVolumeNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->LinkVolume(Path_, Container_, Target_, ReadOnly_, Required_);
}

TTickResult TPortoLinkVolumeNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<void, TPortoError>& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        StatusRepositoryCommon_->UpdateObjectFailedMessage(ObjectIdOrHash_, ToString(result.Error()));
        StatusRepositoryCommon_->IncrementObjectFailCounter(ObjectIdOrHash_);
        if (result.Error().Code == EPortoError::Busy
            // InvalidPath is thrown in case volume overlaps with other volume
            || result.Error().Code == EPortoError::InvalidPath
            || result.Error().Code == EPortoError::VolumeAlreadyLinked
            // mkdirat error is interpreted as Unknown, we can get the real reason only from message
            || (result.Error().Code == EPortoError::Unknown && result.Error().Message.Contains("Disk quota exceeded"))
        ) {
            return TNodeSuccess(ENodeStatus::FAILURE, ToString(result.Error()));
        } else {
            return TNodeError({ToString(result.Error())});
        }
    }
}

} // namespace NInfra::NPodAgent
