#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

#include <infra/pod_agent/libs/pod_agent/status_repository/status_repository_common.h>
#include <infra/pod_agent/libs/pod_agent/status_repository/workload_status_repository.h>

namespace NInfra::NPodAgent {

class TPortoLinkVolumeNode;
using TPortoLinkVolumeNodePtr = TSimpleSharedPtr<TPortoLinkVolumeNode>;

class TPortoLinkVolumeNode : public TPortoBasicNode<TExpected<void, TPortoError>> {
public:
    TPortoLinkVolumeNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TStatusRepositoryCommonPtr statusRepositoryCommon
        , const TString& objectIdOrHash
        , const TString& path
        , const TPortoContainerName& container
        , const TString& target
        , bool readOnly
        , bool required
    )
        : TPortoBasicNode(descriptor, porto)
        , StatusRepositoryCommon_(statusRepositoryCommon)
        , ObjectIdOrHash_(objectIdOrHash)
        , Path_(path)
        , Container_(container)
        , Target_(target)
        , ReadOnly_(readOnly)
        , Required_(required)
    {
        Y_ENSURE(StatusRepositoryCommon_, "StatusRepositoryCommon not defined for TPortoLinkVolumeNode");
        Y_ENSURE(dynamic_cast<TWorkloadStatusRepository*>(statusRepositoryCommon.Get()) == nullptr, "You can't link volume in workload tree");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<void, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_LINK_VOLUME;

private:
    const TStatusRepositoryCommonPtr StatusRepositoryCommon_;
    const TString ObjectIdOrHash_;

    const TString Path_;
    const TPortoContainerName Container_;
    const TString Target_;
    const bool ReadOnly_;
    const bool Required_;
};

} // namespace NInfra::NPodAgent
