#include "porto_remove_layer_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoRemoveLayerNode::GetType() const {
    return TPortoRemoveLayerNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> TPortoRemoveLayerNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->RemoveLayer(LayerName_, LayerPlace_);
}

TTickResult TPortoRemoveLayerNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<void, TPortoError>& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        LayerStatusRepository_->UpdateObjectFailedMessage(LayerDownloadHash_, ToString(result.Error()));
        LayerStatusRepository_->IncrementObjectFailCounter(LayerDownloadHash_);
        if (result.Error().Code == EPortoError::Busy
            || result.Error().Code == EPortoError::InvalidValue  // in case invalid layer name
            || result.Error().Code == EPortoError::LayerNotFound
        ) {
            return TNodeSuccess(ENodeStatus::FAILURE, ToString(result.Error()));
        } else {
            return TNodeError({ToString(result.Error())});
        }
    }
}

} // namespace NInfra::NPodAgent
