#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

#include <infra/pod_agent/libs/pod_agent/status_repository/layer_status_repository.h>

namespace NInfra::NPodAgent {

class TPortoRemoveLayerNode;
using TPortoRemoveLayerNodePtr = TSimpleSharedPtr<TPortoRemoveLayerNode>;

class TPortoRemoveLayerNode : public TPortoBasicNode<TExpected<void, TPortoError>> {
public:
    TPortoRemoveLayerNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TLayerStatusRepositoryPtr layerStatusRepository
        , const TString& layerDownloadHash
        , const TString& layerName
        , const TString& layerPlace
    )
        : TPortoBasicNode(descriptor, porto)
        , LayerStatusRepository_(layerStatusRepository)
        , LayerDownloadHash_(layerDownloadHash)
        , LayerName_(layerName)
        , LayerPlace_(layerPlace)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<void, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_REMOVE_LAYER;

private:
    const TLayerStatusRepositoryPtr LayerStatusRepository_;

    const TString LayerDownloadHash_;
    const TString LayerName_;
    const TString LayerPlace_;
};

} // namespace NInfra::NPodAgent
