#include "porto_remove_storage_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoRemoveStorageNode::GetType() const {
    return TPortoRemoveStorageNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> TPortoRemoveStorageNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->RemoveStorage(Storage_, Place_);
}

TTickResult TPortoRemoveStorageNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<void, TPortoError>& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        // RemoveStorage returns VolumeNotFound if storage does not exist
        if (result.Error().Code == EPortoError::VolumeNotFound) {
            return TNodeSuccess(ENodeStatus::SUCCESS);
        }

        return TNodeError({ToString(result.Error())});
    }
}

} // namespace NInfra::NPodAgent
