#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

namespace NInfra::NPodAgent {

class TPortoRemoveStorageNode;
using TPortoRemoveStorageNodePtr = TSimpleSharedPtr<TPortoRemoveStorageNode>;

class TPortoRemoveStorageNode : public TPortoBasicNode<TExpected<void, TPortoError>> {
public:
    TPortoRemoveStorageNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TString& storage
        , const TString& place
    )
        : TPortoBasicNode(descriptor, porto)
        , Storage_(storage)
        , Place_(place)
    {
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<void, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_REMOVE_STORAGE;

private:
    const TString Storage_;
    const TString Place_;
};

} // namespace NInfra::NPodAgent
