#include "porto_set_container_private_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoSetContainerPrivateNode::GetType() const {
    return TPortoSetContainerPrivateNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> TPortoSetContainerPrivateNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->SetProperty(ContainerName_, EPortoContainerProperty::Private, PackContainerPrivate({Value_, TreeHash_}));
}

TTickResult TPortoSetContainerPrivateNode::ProcessPortoResultError(TTickContextPtr context, TPortoError& result) {
    // Process error
    auto pResult = TPortoBasicContainerNode<void>::ProcessPortoResultError(context, result);

    // Special cases
    if (result.Code == EPortoError::Busy
        || result.Code == EPortoError::ContainerDoesNotExist
        || result.Code == EPortoError::InvalidState
        || result.Code == EPortoError::InvalidValue
    ) {
        return TNodeSuccess(ENodeStatus::FAILURE, ToString(result));
    } else {
        return pResult;
    }
}

} // namespace NInfra::NPodAgent
