#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_container_node.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/base/private_util.h>

namespace NInfra::NPodAgent {

class TPortoSetContainerPrivateNode;
using TPortoSetContainerPrivateNodePtr = TSimpleSharedPtr<TPortoSetContainerPrivateNode>;

class TPortoSetContainerPrivateNode : public TPortoBasicContainerNode<void> {
public:
    TPortoSetContainerPrivateNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TStatusRepositoryCommonPtr containerStatusRepository
        , const NStatusRepositoryTypes::TContainerDescription& container
        , const TPortoContainerName& containerName
        , const TString& treeHash
        , EContainerPrivate value
    )
        : TPortoBasicContainerNode(descriptor, porto, containerStatusRepository, container, containerName)
        , TreeHash_(treeHash)
        , Value_(value)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResultError(TTickContextPtr context, TPortoError& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_SET_CONTAINER_PRIVATE;

private:
    const TString TreeHash_;
    const EContainerPrivate Value_;
};

} // namespace NInfra::NPodAgent
