#include "porto_set_layer_private_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoSetLayerPrivateNode::GetType() const {
    return TPortoSetLayerPrivateNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> TPortoSetLayerPrivateNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->SetLayerPrivate(Value_, Layer_, Place_);
}

TTickResult TPortoSetLayerPrivateNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<void, TPortoError>& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        if (result.Error().Code == EPortoError::Busy
            || result.Error().Code == EPortoError::InvalidValue
            || result.Error().Code == EPortoError::LayerNotFound
        ) {
            return TNodeSuccess(ENodeStatus::FAILURE, ToString(result.Error()));
        } else {
            return TNodeError({ToString(result.Error())});
        }
    }
}

} // namespace NInfra::NPodAgent
