#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

namespace NInfra::NPodAgent {

class TPortoSetLayerPrivateNode;
using TPortoSetLayerPrivateNodePtr = TSimpleSharedPtr<TPortoSetLayerPrivateNode>;

class TPortoSetLayerPrivateNode : public TPortoBasicNode<TExpected<void, TPortoError>> {
public:
    TPortoSetLayerPrivateNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TString& layer
        , const TString& place
        , const TString& value
    )
        : TPortoBasicNode(descriptor, porto)
        , Layer_(layer)
        , Place_(place)
        , Value_(value)
    {
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<void, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_SET_LAYER_PRIVATE;

private:
    const TString Layer_;
    const TString Place_;
    const TString Value_;
};

} // namespace NInfra::NPodAgent
