#include "porto_set_properties_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoSetPropertiesNode::GetType() const {
    return TPortoSetPropertiesNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> TPortoSetPropertiesNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->SetProperties(ContainerName_, Properties_);
}

TTickResult TPortoSetPropertiesNode::ProcessPortoResultError(TTickContextPtr context, TPortoError& result) {
    // Process error
    auto pResult = TPortoBasicContainerNode<void>::ProcessPortoResultError(context, result);

    // Special cases
    if (result.Code == EPortoError::Busy
        || result.Code == EPortoError::ContainerDoesNotExist
        || result.Code == EPortoError::InvalidState
        || result.Code == EPortoError::InvalidValue
    ) {
        return TNodeSuccess(ENodeStatus::FAILURE, ToString(result));
    } else {
        return pResult;
    }
}

} // namespace NInfra::NPodAgent
