#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_container_node.h>

namespace NInfra::NPodAgent {

class TPortoSetPropertiesNode;
using TPortoSetPropertiesNodePtr = TSimpleSharedPtr<TPortoSetPropertiesNode>;

class TPortoSetPropertiesNode : public TPortoBasicContainerNode<void> {
public:
    TPortoSetPropertiesNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TStatusRepositoryCommonPtr containerStatusRepository
        , const NStatusRepositoryTypes::TContainerDescription& container
        , const TPortoContainerName& containerName
        , const TMap<EPortoContainerProperty, TString>& properties
    )
        : TPortoBasicContainerNode(descriptor, porto, containerStatusRepository, container, containerName)
        , Properties_(properties)
    {
        for (const auto& [property, value] : Properties_) {
            Y_ENSURE(!value.empty(), "TPortoSetPropertiesNode must not have empty properties, but " << ToString(property) << " is empty");
        }
        Y_ENSURE(!Properties_.contains(EPortoContainerProperty::Private), "Use TPortoSetContainerPrivateNode for EPortoContainerProperty::Private");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResultError(TTickContextPtr context, TPortoError& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_SET_PROPERTIES;

private:
    const TMap<EPortoContainerProperty, TString> Properties_;
};

} // namespace NInfra::NPodAgent
