#include "porto_set_property_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoSetPropertyNode::GetType() const {
    return TPortoSetPropertyNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> TPortoSetPropertyNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->SetProperty(ContainerName_, Property_, Value_);
}

TTickResult TPortoSetPropertyNode::ProcessPortoResultError(TTickContextPtr context, TPortoError& result) {
    if (IsValueSecret_) {
        result.Args = "<hidden>";
        result.Message = "<hidden>";
    }
    // Process error
    auto pResult = TPortoBasicContainerNode<void>::ProcessPortoResultError(context, result);

    // Special cases
    if (result.Code == EPortoError::Busy
        || result.Code == EPortoError::ContainerDoesNotExist
        || result.Code == EPortoError::InvalidState
        || result.Code == EPortoError::InvalidValue
    ) {
        return TNodeSuccess(ENodeStatus::FAILURE, ToString(result));
    } else {
        return pResult;
    }
}

} // namespace NInfra::NPodAgent
