#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_container_node.h>

namespace NInfra::NPodAgent {

class TPortoSetPropertyNode;
using TPortoSetPropertyNodePtr = TSimpleSharedPtr<TPortoSetPropertyNode>;

class TPortoSetPropertyNode : public TPortoBasicContainerNode<void> {
public:
    TPortoSetPropertyNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TStatusRepositoryCommonPtr containerStatusRepository
        , const NStatusRepositoryTypes::TContainerDescription& container
        , const TPortoContainerName& containerName
        , EPortoContainerProperty property
        , const TString& value
        , const bool isValueSecret
    )
        : TPortoBasicContainerNode(descriptor, porto, containerStatusRepository, container, containerName)
        , Property_(property)
        , Value_(value)
        , IsValueSecret_(isValueSecret)
    {
        Y_ENSURE(Property_ != EPortoContainerProperty::Private, "Use TPortoContainerPrivateMatchesNode for EPortoContainerProperty::Private");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResultError(TTickContextPtr context, TPortoError& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_SET_PROPERTY;

private:
    const EPortoContainerProperty Property_;
    const TString Value_;
    const bool IsValueSecret_;
};

} // namespace NInfra::NPodAgent
