#include "porto_start_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

namespace NInfra::NPodAgent {

ENodeType TPortoStartNode::GetType() const {
    return TPortoStartNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> TPortoStartNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->Start(ContainerName_);
}

TTickResult TPortoStartNode::ProcessPortoResultError(TTickContextPtr context, TPortoError& result) {
    // Process error
    TPortoBasicContainerNode<void>::ProcessPortoResultError(context, result);

    // If this node fails, we need to return FAILURE (not error)
    // because we need to feedback state
    return TNodeSuccess(ENodeStatus::FAILURE, ToString(result));
}

} // namespace NInfra::NPodAgent
