#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_container_node.h>

namespace NInfra::NPodAgent {

class TPortoStartNode;
using TPortoStartNodePtr = TSimpleSharedPtr<TPortoStartNode>;

class TPortoStartNode : public TPortoBasicContainerNode<void> {
public:
    TPortoStartNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TStatusRepositoryCommonPtr containerStatusRepository
        , const NStatusRepositoryTypes::TContainerDescription& container
        , const TPortoContainerName& containerName
    )
        : TPortoBasicContainerNode(descriptor, porto, containerStatusRepository, container, containerName)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResultError(TTickContextPtr context, TPortoError& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_START;
};

} // namespace NInfra::NPodAgent
