#include "porto_static_resource_verify_container_time_expired_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoStaticResourceVerifyContainerTimeExpiredNode::GetType() const {
    return TPortoStaticResourceVerifyContainerTimeExpiredNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> TPortoStaticResourceVerifyContainerTimeExpiredNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->GetProperty(ContainerName_, InitialTime_);
}

TTickResult TPortoStaticResourceVerifyContainerTimeExpiredNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<TString, TPortoError>& result) {
    if (!result) {
        return TNodeError{ToString(result.Error())};
    }

    try {
        time_t startTime = FromString<time_t>(result.Success());
        // porto return time in seconds
        TDuration expireDuration = RoundToSeconds(TDuration::MilliSeconds(StaticResourceStatusRepository_->GetObjectHashMinCheckPeriodMs(StaticResourceDownloadHash_)));
        TInstant expireTime = TInstant::Seconds(startTime) + expireDuration;
        return (expireTime < Now())
            ? TNodeSuccess(ENodeStatus::SUCCESS)
            : TNodeSuccess(
                ENodeStatus::FAILURE
                , TStringBuilder() << "not expired: " << TInstant::Seconds(startTime)
            );
    } catch (TFromStringException& e) {
        return TNodeError{
            TStringBuilder() << "Could not parse DateTime from:" << "'" << result.Success() << "'"
        };
    } catch (const yexception& e) {
        return TNodeError{TStringBuilder() << "node id '" << GetId() << "' title '" << GetTitle() << "': " << e.what()};
    }
}

} // namespace NInfra::NPodAgent
