#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/common.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

#include <infra/pod_agent/libs/pod_agent/status_repository/static_resource_status_repository.h>

namespace NInfra::NPodAgent {

class TPortoStaticResourceVerifyContainerTimeExpiredNode;
using TPortoStaticResourceVerifyContainerTimeExpiredNodePtr = TSimpleSharedPtr<TPortoStaticResourceVerifyContainerTimeExpiredNode>;

class TPortoStaticResourceVerifyContainerTimeExpiredNode : public TPortoBasicNode<TExpected<TString, TPortoError>> {
public:
    TPortoStaticResourceVerifyContainerTimeExpiredNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , TStaticResourceStatusRepositoryPtr staticResourceStatusRepository
        , const TString& staticResourceDownloadHash
        , const TPortoContainerName& containerName
        , EPortoContainerProperty initialTime
    )
        : TPortoBasicNode(descriptor, porto)
        , StaticResourceStatusRepository_(staticResourceStatusRepository)
        , StaticResourceDownloadHash_(staticResourceDownloadHash)
        , ContainerName_(containerName)
        , InitialTime_(initialTime)
    {
        Y_ENSURE(StaticResourceStatusRepository_, "StaticResourceStatusRepository not defined for TPortoStaticResourceVerifyContainerTimeExpiredNode");
        Y_ENSURE(InitialTime_ == EPortoContainerProperty::StartTimeRaw || InitialTime_ == EPortoContainerProperty::CreationTimeRaw,
             "supplied property is not start_time or creation_time");
    }

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<TString, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_STATIC_RESOURCE_VERIFY_CONTAINER_TIME_EXPIRED;

private:
    const TStaticResourceStatusRepositoryPtr StaticResourceStatusRepository_;
    const TString StaticResourceDownloadHash_;
    const TPortoContainerName ContainerName_;
    const EPortoContainerProperty InitialTime_;
};

} // namespace NInfra::NPodAgent
