#include "porto_stop_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoStopNode::GetType() const {
    return TPortoStopNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> TPortoStopNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->Stop(Name_);
}

TTickResult TPortoStopNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<void, TPortoError>& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        if (result.Error().Code == EPortoError::Busy
            || result.Error().Code == EPortoError::ContainerDoesNotExist
            || result.Error().Code == EPortoError::InvalidState
        ) {
            return TNodeSuccess(ENodeStatus::FAILURE, ToString(result.Error()));
        } else {
            return TNodeError({ToString(result.Error())});
        }
    }
}

} // namespace NInfra::NPodAgent
