#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

namespace NInfra::NPodAgent {

class TPortoStopNode;
using TPortoStopNodePtr = TSimpleSharedPtr<TPortoStopNode>;

class TPortoStopNode : public TPortoBasicNode<TExpected<void, TPortoError>> {
public:
    TPortoStopNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TPortoContainerName& name
    )
        : TPortoBasicNode(descriptor, porto)
        , Name_(name)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<void, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_STOP;

private:
    const TPortoContainerName Name_;
};

} // namespace NInfra::NPodAgent
