#include "porto_storage_exists_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoStorageExistsNode::GetType() const {
    return TPortoStorageExistsNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<bool, TPortoError>>, TTickResult> TPortoStorageExistsNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->IsStorageExists(Place_, Storage_);
}

TTickResult TPortoStorageExistsNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<bool, TPortoError>& result) {
    if (result.IsSuccess()) {
        if (result.Success()) {
            return TNodeSuccess(ENodeStatus::SUCCESS, "");
        } else {
            return TNodeSuccess(ENodeStatus::FAILURE, "Storage not found");
        }
    } else {
        return TNodeError({ToString(result.Error())});
    }
}

} // namespace NInfra::NPodAgent
