#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

namespace NInfra::NPodAgent {

class TPortoStorageExistsNode;
using TPortoStorageExistsNodePtr = TSimpleSharedPtr<TPortoStorageExistsNode>;

class TPortoStorageExistsNode : public TPortoBasicNode<TExpected<bool, TPortoError>> {
public:
    TPortoStorageExistsNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TString& place
        , const TString& storage
    )
        : TPortoBasicNode(descriptor, porto)
        , Place_(place)
        , Storage_(storage)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<bool, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<bool, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_STORAGE_EXISTS;

private:
    const TString Place_;
    const TString Storage_;
};

} // namespace NInfra::NPodAgent
