#include "porto_storage_private_matches_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoStoragePrivateMatchesNode::GetType() const {
    return TPortoStoragePrivateMatchesNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> TPortoStoragePrivateMatchesNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->GetStoragePrivate(Place_, Storage_);
}

TTickResult TPortoStoragePrivateMatchesNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<TString, TPortoError>& result) {
    if (!result) {
        // VolumeNotFound is also used for storages in porto
        if (result.Error().Code == EPortoError::VolumeNotFound) {
            return TNodeSuccess(ENodeStatus::FAILURE, TStringBuilder() << "storage '" << Storage_ << "' does not exist");
        }
        return TNodeError{ToString(result.Error())};
    }

    TString value = result.Success();
    return  (value == Value_)
            ? TNodeSuccess(ENodeStatus::SUCCESS)
            : TNodeSuccess(ENodeStatus::FAILURE, TStringBuilder() << "expected '" << Value_ << "' got '" << value << "'");
}

} // namespace NInfra::NPodAgent
