#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

namespace NInfra::NPodAgent {

class TPortoStoragePrivateMatchesNode;
using TPortoStoragePrivateMatchesNodePtr = TSimpleSharedPtr<TPortoStoragePrivateMatchesNode>;

class TPortoStoragePrivateMatchesNode : public TPortoBasicNode<TExpected<TString, TPortoError>> {
public:
    TPortoStoragePrivateMatchesNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TString& storage
        , const TString& place
        , const TString& value
    )
        : TPortoBasicNode(descriptor, porto)
        , Storage_(storage)
        , Place_(place)
        , Value_(value)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TString, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<TString, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_STORAGE_PRIVATE_MATCHES;

private:
    const TString Storage_;
    const TString Place_;
    const TString Value_;
};

} // namespace NInfra::NPodAgent
