#include "porto_storage_private_matches_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>
#include <infra/pod_agent/libs/porto_client/mock_client.h>

#include <infra/libs/logger/logger.h>
#include <infra/libs/logger/log_frame.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

namespace NInfra::NPodAgent::NTestPortoStoragePrivateMatchesNode {

Y_UNIT_TEST_SUITE(PortoStoragePrivateMatchesNodeSuite) {

static TLogger logger({});

TPortoStoragePrivateMatchesNodePtr CreateNode(TAsyncPortoClientPtr porto, const TString& storage, const TString& place, const TString& value) {
    return new TPortoStoragePrivateMatchesNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , porto
        , storage
        , place
        , value
    );
}

Y_UNIT_TEST(TestPropertyMatches) {
    struct TMyPortoClient : public TMockPortoClient {
        TExpected<TString, TPortoError> GetStoragePrivate(const TString& place, const TString& name) override {
            Name_ = name;
            Place_ = place;

            return TString("value");
        }

        TString Name_ = TString("");
        TString Place_ = TString("");
    };

    TPortoClientPtr myPorto = new TMyPortoClient();
    TAsyncPortoClientPtr porto = new TAsyncPortoClient(myPorto, new TFakeThreadPool());

    const TString name = "storage_0";
    const TString place = "some_place";

    auto creator = CreateNode(porto, name, place, "value");
    auto result = creator->Tick(MockTickContext(logger));

    UNIT_ASSERT_EQUAL(ENodeStatus::SUCCESS, result.Success().Status);
    UNIT_ASSERT_EQUAL(name, ((TMyPortoClient*)myPorto.Get())->Name_);
    UNIT_ASSERT_EQUAL(place, ((TMyPortoClient*)myPorto.Get())->Place_);
}

Y_UNIT_TEST(TestPropertyNotMatches) {
    struct TMyPortoClient : public TMockPortoClient {
        TExpected<TString, TPortoError> GetStoragePrivate(const TString& place, const TString& name) override {
            Name_ = name;
            Place_ = place;

            return TString("wrong_value");
        }
        TString Name_ = TString("");
        TString Place_ = TString("");
    };

    TPortoClientPtr myPorto = new TMyPortoClient();
    TAsyncPortoClientPtr porto = new TAsyncPortoClient(myPorto, new TFakeThreadPool());

    const TString name = "storage_0";
    const TString place = "some_place";

    auto creator = CreateNode(porto, name, place, "value");
    auto result = creator->Tick(MockTickContext(logger));

    UNIT_ASSERT_EQUAL(ENodeStatus::FAILURE, result.Success().Status);
    UNIT_ASSERT_EQUAL(name, ((TMyPortoClient*)myPorto.Get())->Name_);
    UNIT_ASSERT_EQUAL(place, ((TMyPortoClient*)myPorto.Get())->Place_);
}

Y_UNIT_TEST(TestStorageNotFound) {
    struct TMyPortoClient : public TMockPortoClient {
        TExpected<TString, TPortoError> GetStoragePrivate(const TString& place, const TString& name) override {
            Name_ = name;
            Place_ = place;

            return TPortoError{EPortoError::VolumeNotFound, "", ""};
        }

        TString Name_ = TString("");
        TString Place_ = TString("");
    };

    TPortoClientPtr myPorto = new TMyPortoClient();
    TAsyncPortoClientPtr porto = new TAsyncPortoClient(myPorto, new TFakeThreadPool());

    const TString name = "storage_0";
    const TString place = "some_place";

    auto creator = CreateNode(porto, name, place, "value");
    auto result = creator->Tick(MockTickContext(logger));

    UNIT_ASSERT_EQUAL(ENodeStatus::FAILURE, result.Success().Status);
    UNIT_ASSERT_EQUAL(name, ((TMyPortoClient*)myPorto.Get())->Name_);
    UNIT_ASSERT_EQUAL(place, ((TMyPortoClient*)myPorto.Get())->Place_);
}

}

} // namespace NInfra::NPodAgent::NTestPortoStoragePrivateMatchesNode
