#include "porto_unlink_volume_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoUnlinkVolumeNode::GetType() const {
    return TPortoUnlinkVolumeNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<void, TPortoError>>, TTickResult> TPortoUnlinkVolumeNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->UnlinkVolume(Path_, Container_, Target_, Strict_);
}

TTickResult TPortoUnlinkVolumeNode::ProcessPortoResult(TTickContextPtr /* context */, TExpected<void, TPortoError>& result) {
    if (result) {
        return TNodeSuccess(ENodeStatus::SUCCESS);
    } else {
        StatusRepositoryCommon_->UpdateObjectFailedMessage(ObjectIdOrHash_, ToString(result.Error()));
        StatusRepositoryCommon_->IncrementObjectFailCounter(ObjectIdOrHash_);
        if (result.Error().Code == EPortoError::Busy
            || result.Error().Code == EPortoError::ContainerDoesNotExist
            || result.Error().Code == EPortoError::VolumeNotFound
            || result.Error().Code == EPortoError::VolumeNotLinked
        ) {
            return TNodeSuccess(ENodeStatus::FAILURE, ToString(result.Error()));
        } else {
            return TNodeError({ToString(result.Error())});
        }
    }
}

} // namespace NInfra::NPodAgent
