#include "porto_utils.h"

namespace NInfra::NPodAgent {

TExpected<TString, TNodeError> PropertiesToString(
    const TPortoContainerName& containerName,
    const TVector<EPortoContainerProperty>& properties,
    const TMap<EPortoContainerProperty, TPortoGetResponse>& propertiesMap,
    const TString& delimiter
) {
    TStringBuilder stringBuilder;
    for (auto& property : properties) {
        auto ptr = propertiesMap.FindPtr(property);

        if (!ptr) {
            return TNodeError{TStringBuilder() << "List of container '" << TString(containerName) << "' properties incomplete: " << ToString(property) << " missed"};
        }
        if (ptr->error()) {
            return TNodeError{TStringBuilder() << ToString(ptr->error()) << ':' << ptr->errormsg()};
        }
        if (!stringBuilder.empty()) {
            stringBuilder << delimiter;
        }

        stringBuilder << ToString(property) << " = '" << ptr->value() << "'";
    }
    return TString(stringBuilder);
}

}
