#include "porto_utils.h"

#include <infra/pod_agent/libs/porto_client/test_functions.h>

#include <library/cpp/testing/unittest/registar.h>

namespace NInfra::NPodAgent::NTestPortoUtils {

static const TVector<EPortoContainerProperty> PROPERTIES = {
    EPortoContainerProperty::ExitCode
    , EPortoContainerProperty::StdErr
};

Y_UNIT_TEST_SUITE(PortoUtilsSuite) {

Y_UNIT_TEST(PropertiesToStringTest) {
    TMap<EPortoContainerProperty, TPortoGetResponse> propertiesMap = {
        {EPortoContainerProperty::ExitCode, NPortoTest::CreateTPortoGetResponse("100", 0, "")},
        {EPortoContainerProperty::StdErr, NPortoTest::CreateTPortoGetResponse("stderr!", 0, "")}
    };
    TPortoContainerName container("my_container");
    auto result = PropertiesToString(container, PROPERTIES, propertiesMap, ", ");
    UNIT_ASSERT(result);
    UNIT_ASSERT_EQUAL_C(result.Success(), "exit_code = '100', stderr = 'stderr!'", result.Success());
}

Y_UNIT_TEST(PropertiesToStringErrorWhenMissedPropertyTest) {
    TMap<EPortoContainerProperty, TPortoGetResponse> propertiesMap = {
        {EPortoContainerProperty::ExitCode, NPortoTest::CreateTPortoGetResponse("100", 0, "")},
        {EPortoContainerProperty::StdOut, NPortoTest::CreateTPortoGetResponse("stdout!", 0, "")}
    };
    TPortoContainerName container("my_container");
    auto result = PropertiesToString(container, PROPERTIES, propertiesMap, ", ");
    UNIT_ASSERT(!result);
    UNIT_ASSERT_EQUAL_C(
        result.Error().Message,
        TStringBuilder() << "List of container '" << container << "' properties incomplete: " << EPortoContainerProperty::StdErr << " missed",
        result.Error().Message);
}

Y_UNIT_TEST(PropertiesToStringErrorWhenFailedGetResponseTest) {
    TMap<EPortoContainerProperty, TPortoGetResponse> propertiesMap = {
        {EPortoContainerProperty::ExitCode, NPortoTest::CreateTPortoGetResponse("100", 0, "")},
        {EPortoContainerProperty::StdErr, NPortoTest::CreateTPortoGetResponse("", 5, "Porto error")}
    };
    TPortoContainerName container("my_container");
    auto result = PropertiesToString(container, PROPERTIES, propertiesMap, ", ");
    UNIT_ASSERT(!result);
    UNIT_ASSERT_EQUAL_C(result.Error().Message,"InvalidProperty:Porto error", result.Error().Message);
}

}

} // namespace NInfra::NPodAgent::NTestPortoUnlinkVolumeNode
