#include "porto_volume_exists_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoVolumeExistsNode::GetType() const {
    return TPortoVolumeExistsNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<int, TPortoError>>, TTickResult> TPortoVolumeExistsNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->IsVolumeExists(Path_);
}

TTickResult TPortoVolumeExistsNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<int, TPortoError>& result) {
    if (result) {
        if (result.Success()) {
            return TNodeSuccess(ENodeStatus::SUCCESS, "");
        } else {
            return TNodeSuccess(ENodeStatus::FAILURE, "Volume not found");
        }
    } else {
        return TNodeError({ToString(result.Error())});
    }
}

} // namespace NInfra::NPodAgent
