#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

namespace NInfra::NPodAgent {

class TPortoVolumeExistsNode;
using TPortoVolumeExistsNodePtr = TSimpleSharedPtr<TPortoVolumeExistsNode>;

class TPortoVolumeExistsNode : public TPortoBasicNode<TExpected<int, TPortoError>> {
public:
    TPortoVolumeExistsNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TString& path
    )
        : TPortoBasicNode(descriptor, porto)
        , Path_(path)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<int, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<int, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_VOLUME_EXISTS;

private:
    const TString Path_;
};

} // namespace NInfra::NPodAgent
