#include "porto_volume_is_link_of_node.h"

namespace NInfra::NPodAgent {

ENodeType TPortoVolumeIsLinkOfNode::GetType() const {
    return TPortoVolumeIsLinkOfNode::NODE_TYPE;
}

TExpected<TFuture<TExpected<TVector<TPortoVolume>, TPortoError>>, TTickResult> TPortoVolumeIsLinkOfNode::PortoCall(TTickContextPtr /*context*/) {
    return Porto_->ListVolumes(Path_);
}

TTickResult TPortoVolumeIsLinkOfNode::ProcessPortoResult(TTickContextPtr /*context*/, TExpected<TVector<TPortoVolume>, TPortoError>& result) {
    if (result) {
        for (TPortoVolume& vol : result.Success()) {
            if (vol.path() == Path_) {
                for (const TPortoVolumeLink& linkVolume : vol.links()) {
                    if (linkVolume.target() == Target_) {
                        if (Container_ != TString("IGNORE_CONTAINER_NAME") && Container_ != linkVolume.container()) {
                            return TNodeSuccess(ENodeStatus::FAILURE, TStringBuilder() << "Target volume '" << Target_ << "' linked to path volume '" << Path_ << "' but with wrong container");
                        }
                        if (ReadOnly_ != linkVolume.read_only()) {
                            return TNodeSuccess(ENodeStatus::FAILURE, TStringBuilder() << "Target volume '" << Target_ << "' linked to path volume '" << Path_ << "' but with wrong read mode");
                        }
                        if (Required_ != linkVolume.required()) {
                            return TNodeSuccess(ENodeStatus::FAILURE, TStringBuilder() << "Target volume '" << Target_ << "' linked to path volume '" << Path_ << "' but with wrong require mode");
                        }
                        return TNodeSuccess(ENodeStatus::SUCCESS);
                    }
                }
                return TNodeSuccess(ENodeStatus::FAILURE, TStringBuilder() << "Target volume '" << Target_ << "' not linked to path volume '" << Path_ << "'");
            }
        }
        return TNodeError({"Path volume not found"});
    } else {
        return TNodeError({ToString(result.Error())});
    }
}

} // namespace NInfra::NPodAgent
