#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>

namespace NInfra::NPodAgent {

class TPortoVolumeIsLinkOfNode;
using TPortoVolumeIsLinkOfNodePtr = TSimpleSharedPtr<TPortoVolumeIsLinkOfNode>;

class TPortoVolumeIsLinkOfNode : public TPortoBasicNode<TExpected<TVector<TPortoVolume>, TPortoError>> {
public:
    TPortoVolumeIsLinkOfNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , const TString& path
        , const TPortoContainerName& container
        , const TString& target
        , bool readOnly
        , bool required
    )
        : TPortoBasicNode(descriptor, porto)
        , Path_(path)
        , Container_(container)
        , Target_(target)
        , ReadOnly_(readOnly)
        , Required_(required)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual TExpected<TFuture<TExpected<TVector<TPortoVolume>, TPortoError>>, TTickResult> PortoCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPortoResult(TTickContextPtr context, TExpected<TVector<TPortoVolume>, TPortoError>& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::PORTO_VOLUME_IS_LINK_OF;

private:
    const TString Path_;
    const TPortoContainerName Container_;
    const TString Target_;
    const bool ReadOnly_;
    const bool Required_;
};

} // namespace NInfra::NPodAgent
