#include "check_same_inode_node.h"

namespace NInfra::NPodAgent {

ENodeType TCheckSameINodeNode::GetType() const {
    return TCheckSameINodeNode::NODE_TYPE;
}

NThreading::TFuture<TPosixCheckResult> TCheckSameINodeNode::PosixCall(TTickContextPtr /* context */) {
    return Posix_->CheckSameINodeAsync(Path1_, Path2_);
}

TTickResult TCheckSameINodeNode::ProcessPosixResult(TTickContextPtr /* context */, TPosixCheckResult& result) {
    if (!result) {
        return TNodeError({ToString(result.Error())});
    }

    if (!result.Success()) {
        return TNodeSuccess(ENodeStatus::FAILURE);
    }

    return TNodeSuccess(ENodeStatus::SUCCESS);
}

} // namespace NInfra::NPodAgent
