#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/posix_basic_node.h>

namespace NInfra::NPodAgent {

class TCheckSameINodeNode;
using TCheckSameINodeNodePtr = TSimpleSharedPtr<TCheckSameINodeNode>;

class TCheckSameINodeNode : public TPosixBasicNode<TPosixCheckResult> {
public:
    TCheckSameINodeNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TPosixWorkerPtr posix
        , const TString& path1
        , const TString& path2
    )
        : TPosixBasicNode<TPosixCheckResult>(descriptor, posix)
        , Path1_(path1)
        , Path2_(path2)
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual NThreading::TFuture<TPosixCheckResult> PosixCall(TTickContextPtr context) override final;
    virtual TTickResult ProcessPosixResult(TTickContextPtr context, TPosixCheckResult& result) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::CHECK_SAME_INODE;

private:
    const TString Path1_;
    const TString Path2_;
};

} // namespace NInfra::NPodAgent
