#include "file_exist_node.h"

namespace NInfra::NPodAgent {

ENodeType TFileExistNode::GetType() const {
    return TFileExistNode::NODE_TYPE;
}

NThreading::TFuture<TPosixCheckResult> TFileExistNode::PosixCall(TTickContextPtr /*context*/) {
    return Posix_->ExistsAsync(Path_);
}

TTickResult TFileExistNode::ProcessPosixResult(TTickContextPtr /*context*/, TPosixCheckResult& result) {
    if (!result) {
        return TNodeError({ToString(result.Error())});
    }

    if (!result.Success()) {
        return TNodeSuccess(ENodeStatus::FAILURE);
    }

    return TNodeSuccess(ENodeStatus::SUCCESS);
}

} // namespace NInfra::NPodAgent
