#include "file_exist_node.h"

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/test/mock_tick_context.h>

#include <library/cpp/testing/unittest/registar.h>
#include <library/cpp/testing/unittest/tests_data.h>

#include <util/stream/file.h>

namespace NInfra::NPodAgent::NTestFileExistNode {

static TLogger logger({});

void CreateFile(const TString& path) {
    TOFStream flag(path);
    flag.Flush();
    flag.Finish();
}

Y_UNIT_TEST_SUITE(ExistFileNodeSuite) {

Y_UNIT_TEST(ExistFileSuccess) {
    const TString filePath = "flag";
    CreateFile(filePath);
    TAtomicSharedPtr<IThreadPool> pool = new TFakeThreadPool;
    TPosixWorkerPtr posixWorker = new TPosixWorker(pool);

    TFileExistNodePtr node = new TFileExistNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , filePath
        , posixWorker
    );

    auto tickResult = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_C((bool)tickResult, tickResult.Error().Message);
    UNIT_ASSERT_EQUAL(ENodeStatus::SUCCESS, tickResult.Success().Status);
}

Y_UNIT_TEST(ExistFileFailure) {
    TAtomicSharedPtr<IThreadPool> pool = new TFakeThreadPool;
    TPosixWorkerPtr posixWorker = new TPosixWorker(pool);

    TFileExistNodePtr node = new TFileExistNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , "flag_other"
        , posixWorker
    );

    auto tickResult = node->Tick(MockTickContext(logger));
    UNIT_ASSERT_EQUAL(ENodeStatus::FAILURE, tickResult.Success().Status);
}

Y_UNIT_TEST(ExistFileError) {
    struct TMyPosixFailingClient : public TPosixWorker {
        TMyPosixFailingClient() : TPosixWorker(nullptr) {}

        NThreading::TFuture<TPosixCheckResult> ExistsAsync(const TString& path) override {
            ++Calls;
            LastPath = path;

            auto result = NThreading::NewPromise<TPosixCheckResult>();
            result.SetValue(TPosixError{-1, "ExistsAsync"});

            return result;
        }

        size_t Calls = 0;
        TString LastPath = "";
    };

    TPosixWorkerPtr posixWorker = new TMyPosixFailingClient();

    TString path = "flag_other";
    TFileExistNodePtr node = new TFileExistNode(
        TBasicTreeNodeDescriptor{1, "title"}
        , path
        , posixWorker
    );

    auto result = node->Tick(MockTickContext(logger));

    UNIT_ASSERT_STRING_CONTAINS(result.Error().Message, "ExistsAsync");
    UNIT_ASSERT_EQUAL(1, ((TMyPosixFailingClient*)posixWorker.Get())->Calls);
    UNIT_ASSERT_EQUAL(path, ((TMyPosixFailingClient*)posixWorker.Get())->LastPath);
}

}

} // namespace NInfra::NPodAgent::NTestFileExistNode
