#include "file_modified_before_porto_container_start_node.h"

namespace NInfra::NPodAgent {

ENodeType TFileModifiedBeforePortoContainerStartNode::GetType() const {
    return TFileModifiedBeforePortoContainerStartNode::NODE_TYPE;
}

NThreading::TFuture<TExpected<time_t, TPosixError>> TFileModifiedBeforePortoContainerStartNode::GetPosixTimeResult() {
    return Posix_->GetFileModificationTimeAsync(Path_);
}

TExpected<time_t, TPosixError> TFileModifiedBeforePortoContainerStartNode::GetModificationTimeFromPosixResult(const TExpected<time_t, TPosixError>& posixTimeResult) {
    return posixTimeResult;
}

} // namespace NInfra::NPodAgent
