#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/modified_before_porto_container_start_basic_node.h>

namespace NInfra::NPodAgent {

class TFileModifiedBeforePortoContainerStartNode;
using TFileModifiedBeforePortoContainerStartNodePtr = TSimpleSharedPtr<TFileModifiedBeforePortoContainerStartNode>;

class TFileModifiedBeforePortoContainerStartNode : public TModifiedBeforePortoContainerStartBasicNode<TExpected<time_t, TPosixError> > {
public:
    TFileModifiedBeforePortoContainerStartNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , TPosixWorkerPtr posixWorker
        , const TPortoContainerName& containerName
        , const TString& filePath
    )
        : TModifiedBeforePortoContainerStartBasicNode(
            descriptor
            , porto
            , posixWorker
            , containerName
            , filePath
        )
    {}

    virtual ENodeType GetType() const override final;

private:
    virtual NThreading::TFuture<TExpected<time_t, TPosixError>> GetPosixTimeResult() override final;
    virtual TExpected<time_t, TPosixError> GetModificationTimeFromPosixResult(const TExpected<time_t, TPosixError>& posixTimeResult) override final;

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::FILE_MODIFIED_BEFORE_PORTO_CONTAINER_START;
};

} // namespace NInfra::NPodAgent
