#pragma once

#include <infra/pod_agent/libs/behaviour/bt/nodes/base/common.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/base/compare_times_types.h>
#include <infra/pod_agent/libs/behaviour/bt/nodes/base/porto_basic_node.h>
#include <infra/pod_agent/libs/posix_worker/posix_worker.h>

namespace NInfra::NPodAgent {

class TFileModifiedBeforePortoVolumeBuildNode;
using TFileModifiedBeforePortoVolumeBuildNodePtr = TSimpleSharedPtr<TFileModifiedBeforePortoVolumeBuildNode>;

class TFileModifiedBeforePortoVolumeBuildNode : public TPortoBasicNode<TExpected<TCompareTimesResult, TModifiedTimeError>> {
public:
    TFileModifiedBeforePortoVolumeBuildNode(
        const TBasicTreeNodeDescriptor& descriptor
        , TAsyncPortoClientPtr porto
        , TPosixWorkerPtr posixWorker
        , const TString& volumePath
        , const TString& filePath
    )
        : TPortoBasicNode(descriptor, porto)
        , Posix_(posixWorker)
        , VolumePath_(volumePath)
        , FilePath_(filePath)
    {
        Y_ENSURE(Posix_, "Posix not defined for TFileModifiedBeforePortoVolumeBuildNode");
    }

    ENodeType GetType() const override;

private:
    TExpected<TFuture<TExpected<TCompareTimesResult, TModifiedTimeError>>, TTickResult> PortoCall(TTickContextPtr /*context*/) override;

    TExpected<TCompareTimesResult, TModifiedTimeError> CompareTimes(
        const TExpected<time_t, TPortoError>& volumeBuildTimeResult
        , const TExpected<time_t, TPosixError>& fileModificationTimeResult
    );

    TTickResult ProcessPortoResult(TTickContextPtr /*context*/, TExpected<TCompareTimesResult, TModifiedTimeError>& result) override;

    TFuture<TExpected<time_t, TPortoError>> GetVolumeBuildTime();

    NThreading::TFuture<TExpected<time_t, TPosixError>> GetFileModificationTime();

public:
    static constexpr const ENodeType NODE_TYPE = ENodeType::FILE_MODIFIED_BEFORE_PORTO_VOLUME_BUILD;

private:
    TPosixWorkerPtr Posix_;
    const TString VolumePath_;
    const TString FilePath_;
};

} // namespace NInfra::NPodAgent
