#include "file_modified_recursive_before_porto_container_start_node.h"

namespace NInfra::NPodAgent {

ENodeType TFileModifiedRecursiveBeforePortoContainerStartNode::GetType() const {
    return TFileModifiedRecursiveBeforePortoContainerStartNode::NODE_TYPE;
}

NThreading::TFuture<TExpected<TList<time_t>, TPosixError>> TFileModifiedRecursiveBeforePortoContainerStartNode::GetPosixTimeResult() {
    return Posix_->GetFileModificationTimeRecursiveAsync(Path_);
}

TExpected<time_t, TPosixError> TFileModifiedRecursiveBeforePortoContainerStartNode::GetModificationTimeFromPosixResult(const TExpected<TList<time_t>, TPosixError>& posixTimeResult) {
    auto modificationTimes = OUTCOME_TRYX(posixTimeResult);
    if (!modificationTimes.size())
        return TPosixError{-1, TStringBuilder() << "modification time collection is empty, path: " << Path_};
    return modificationTimes.back();
}

} // namespace NInfra::NPodAgent
